AnimatedSprite = {
	__index = {
		new = function(self, _r, _d, _file, _duration )

			self.Tile ={
				r = _r,
				d = _d
			}

			self.EventIndex = nil

			self.Actor = function(i)

				return Def.Sprite{

					Texture=THEME:GetPathB("Overworld", "overlay/Sprites/AnimatedSprites/" .. _file ),
					LoadCommand=function(subself)
						subself:animate(1)

						-- align to left and v-middle
							:halign(0):valign(0.5)

						-- set the position
							:x( _r * SRT.TileData.TileSize )
							:y( _d * SRT.TileData.TileSize )
							:z( -(SRT.TileData.Height.Tiles - _d) )

						-- set the duration of one frame of animation
							:SetAllStateDelays(_duration)

						-- mark the MapData where the event is as collidable
						SRT.TileData.CollisionTiles[_d * SRT.TileData.Width.Tiles + _r + 1] = 1
					end
				}
			end

			self.Trigger = nil
			self.Action = nil

			return self
		end
	}
}